﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using DataAccess;
using MDWSLib.MDWSEmrSvc;
using ext = Ext.Net;

//setup an alias for all direct method calls on this page
[ext.DirectMethodProxyID(IDMode = ext.DirectMethodProxyIDMode.Alias, Alias = "PATLOOKUP")]


/// <summary>
/// user control to lookup patients
/// </summary>
public partial class ucPatLookup : System.Web.UI.UserControl
{
    public BaseMaster BaseMstr { get; set; }
    public CDataUtils m_utils = new CDataUtils();
    public long lOpenCasesCount;
    public DataSet dsOpenCases;

    public void Show() 
    {
        winPatLookup.Show();
    }

    /// <summary>
    /// US:5349 page load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
       
    }

    [Ext.Net.DirectMethod]
    public void InitializeLookupWindow() {
        txtSearch.Text = string.Empty;
        radLastName.Checked = true;
        divPatLookupStatus.Hide();
        sPatientLookup.RemoveAll();
        gpPatientLookup.Refresh();
       
    }

    /// <summary>
    /// US:5349 user clicked the search button
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    [Ext.Net.DirectMethod( ShowMask = true, Msg="<span role='alert'>Please wait.</span>", Timeout = 90000)]
    public void LookupPatient()
    {
        //clear the lookup status
        //divPatLookupStatus.InnerHtml = String.Empty;
                
        //convert the search to upper case
        string strSearchText = "";
        strSearchText = txtSearch.Text.ToUpper();

        //full mdws support
        CStatus statxfer = new CStatus();
        if (BaseMstr.MDWSTransfer)
        {
            //1 = last name, 2 = LSSN
            long lMatchType = Convert.ToInt32(rblSearchType.CheckedItems[0].InputValue);
            if (lMatchType == 3)
            {
                lMatchType = 2;
            }

            //transfer patients from MDWS to central db
           statxfer = MDWSPatientXfer(lMatchType, strSearchText);
        }

        //if we have a patient looked up then re-select them
        //this is because we select in MDWSPatientXfer to move over patient data
        //and if the user cancels the lookup we need to make sure the original
        //patient is reselected.
        if (!String.IsNullOrEmpty(BaseMstr.DFN))
        {
            string strPatID = "";
            CMDWSOps opsPat = new CMDWSOps(this.BaseMstr.GetDataObject());
            CStatus stat = opsPat.TransferPatientByDFN(this.BaseMstr.Key,
                                                       this.BaseMstr.DFN,
                                                       out strPatID);
        }

        if (!statxfer.Status)
        {
            BaseMstr.ShowSystemFeedback("Error looking up patient: " + statxfer.StatusComment, "Error");
            return;
        }

        //do the lookup from the local database
        CPatient pat = new CPatient();
        DataSet ds = pat.GetPatientLookupDS(BaseMstr,
                                            1,
                                            Convert.ToInt32(rblSearchType.CheckedItems[0].InputValue),
                                            strSearchText
                                            );

        //bind the ds to the store
        if (ds != null)
        {
            sPatientLookup.DataSource = m_utils.GetDataTable(ds);
            sPatientLookup.DataBind();
            
            if (ds.Tables[0].Rows.Count < 1) 
            {
                ShowLookupMesage();
            }
        }
        else
        {
            ShowLookupMesage();
        }

        //register script block for radios
        //ScriptManager.RegisterClientScriptBlock(upPatLookup, typeof(string), "initRadios", "InitRadios();", true);
    }

    /// <summary>
    /// US:5349 show patient lookup message
    /// </summary>
    public void ShowLookupMesage() 
    {
        this.divPatLookupStatus.Show();
        ext.X.Call("clearLookupStatusDiv", 4);
    }

    
    /// <summary>
    /// US:5349 transfer patients from MDWS to the central db
    /// </summary>
    /// <param name="lMatchType"></param>
    /// <param name="strSearch"></param>
    /// <returns></returns>
    protected CStatus MDWSPatientXfer(long lMatchType, string strSearch)
    {
        Session["PING_MDWS"] = "1";

        //transfer the patient(s)
        long lPatCount = 0;

        //connect to MDWS lib
        CMDWSOps mdws = new CMDWSOps(BaseMstr.GetDataObject());

        //transfer patients matching search criteria
        CStatus status = mdws.TransferMatchPatients(BaseMstr.Key,
                                                    lMatchType,
                                                    strSearch,
                                                    out lPatCount);

        BaseMstr.Session["PING_MDWS"] = null;
        

        return status;
    }   
}

